<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'Klinik Kecantikan') }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <!--<link href="https://fonts.googleapis.com/css2?family=Abel:wght@400&display=swap" rel="stylesheet" />-->
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
</head>

<body class="font-abel antialiased">
    <div class="min-h-screen bg-white">
        <!-- Top Header -->
        <div class="bg-white text-black py-2">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center">
                    <div class="text-sm">
                        <span>Dukuh, Tridadi, Kec. Sleman, Kab. Sleman Yogyakarta</span>
                    </div>
                    <div class="flex items-center space-x-4">
                        
                        <a href="#" class="text-gray-600 hover:text-gray-800">
                            <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-white" viewBox="0 0 640 640">
                                    <path fill="#ffffff" d="M320.3 205C256.8 204.8 205.2 256.2 205 319.7C204.8 383.2 256.2 434.8 319.7 435C383.2 435.2 434.8 383.8 435 320.3C435.2 256.8 383.8 205.2 320.3 205zM319.7 245.4C360.9 245.2 394.4 278.5 394.6 319.7C394.8 360.9 361.5 394.4 320.3 394.6C279.1 394.8 245.6 361.5 245.4 320.3C245.2 279.1 278.5 245.6 319.7 245.4zM413.1 200.3C413.1 185.5 425.1 173.5 439.9 173.5C454.7 173.5 466.7 185.5 466.7 200.3C466.7 215.1 454.7 227.1 439.9 227.1C425.1 227.1 413.1 215.1 413.1 200.3zM542.8 227.5C541.1 191.6 532.9 159.8 506.6 133.6C480.4 107.4 448.6 99.2 412.7 97.4C375.7 95.3 264.8 95.3 227.8 97.4C192 99.1 160.2 107.3 133.9 133.5C107.6 159.7 99.5 191.5 97.7 227.4C95.6 264.4 95.6 375.3 97.7 412.3C99.4 448.2 107.6 480 133.9 506.2C160.2 532.4 191.9 540.6 227.8 542.4C264.8 544.5 375.7 544.5 412.7 542.4C448.6 540.7 480.4 532.5 506.6 506.2C532.8 480 541 448.2 542.8 412.3C544.9 375.3 544.9 264.5 542.8 227.5zM495 452C487.2 471.6 472.1 486.7 452.4 494.6C422.9 506.3 352.9 503.6 320.3 503.6C287.7 503.6 217.6 506.2 188.2 494.6C168.6 486.8 153.5 471.7 145.6 452C133.9 422.5 136.6 352.5 136.6 319.9C136.6 287.3 134 217.2 145.6 187.8C153.4 168.2 168.5 153.1 188.2 145.2C217.7 133.5 287.7 136.2 320.3 136.2C352.9 136.2 423 133.6 452.4 145.2C472 153 487.1 168.1 495 187.8C506.7 217.3 504 287.3 504 319.9C504 352.5 506.7 422.6 495 452z"/>
                                </svg>
                            </div>
                        </a>
                        <a href="#" class="text-gray-600 hover:text-gray-800">
                            <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                               <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-white"  viewBox="0 0 640 640">
                                   <path fill="#ffffff" d="M544.5 273.9C500.5 274 457.5 260.3 421.7 234.7L421.7 413.4C421.7 446.5 411.6 478.8 392.7 506C373.8 533.2 347.1 554 316.1 565.6C285.1 577.2 251.3 579.1 219.2 570.9C187.1 562.7 158.3 545 136.5 520.1C114.7 495.2 101.2 464.1 97.5 431.2C93.8 398.3 100.4 365.1 116.1 336C131.8 306.9 156.1 283.3 185.7 268.3C215.3 253.3 248.6 247.8 281.4 252.3L281.4 342.2C266.4 337.5 250.3 337.6 235.4 342.6C220.5 347.6 207.5 357.2 198.4 369.9C189.3 382.6 184.4 398 184.5 413.8C184.6 429.6 189.7 444.8 199 457.5C208.3 470.2 221.4 479.6 236.4 484.4C251.4 489.2 267.5 489.2 282.4 484.3C297.3 479.4 310.4 469.9 319.6 457.2C328.8 444.5 333.8 429.1 333.8 413.4L333.8 64L421.8 64C421.7 71.4 422.4 78.9 423.7 86.2C426.8 102.5 433.1 118.1 442.4 131.9C451.7 145.7 463.7 157.5 477.6 166.5C497.5 179.6 520.8 186.6 544.6 186.6L544.6 274z"/>
                                </svg>
                            </div>
                        </a>
                        <a href="#" class="text-gray-600 hover:text-gray-800">
                            <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path
                                        d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                                </svg>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Navigation -->
        <nav class="bg-[#3A3A3A] shadow-lg">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-24">
                    <div class="flex items-center">
                        <div class="flex items-center">
                            <div class="mr-3 shrink-0">
                                <img src="{{ asset('images/logo/logo-baru.png') }}" alt="Logo Zen"
                                    class="h-16 md:h-20 lg:h-20 w-auto object-contain"
                                    onerror="this.classList.add('hidden'); this.nextElementSibling.classList.remove('hidden');">
                                <div
                                    class="hidden w-16 h-16 md:w-20 md:h-20 lg:w-24 lg:h-24 bg-gray-200 rounded-full items-center justify-center">
                                    <span class="text-gray-600 font-bold text-2xl md:text-3xl lg:text-4xl">Z</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-6">
                            <a href="https://demowebjalan.com/klinikzenjogja/"
                                class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold transition-all duration-200 hover:bg-white hover:bg-opacity-10">HOME</a>
                            <a href="https://demowebjalan.com/klinikzenjogja/tentang-kami/"
                                class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold transition-all duration-200 hover:bg-white hover:bg-opacity-10">TENTANG
                                KAMI</a>
                            <div class="relative group">
                                <a href="#"
                                    class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold flex items-center transition-all duration-200 hover:bg-white hover:bg-opacity-10">
                                    LAYANAN
                                    <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </a>

                                <!-- Dropdown Menu -->
                                <div
                                    class="absolute left-0 mt-2 w-80 bg-white shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50 border border-gray-200">
                                    <div class="py-2">
                                        <!-- Bedah Plastik -->
                                        <div class="relative group/sub">
                                            <a href="#"
                                                class="flex items-center justify-between px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                                <span class="text-sm font-medium">Bedah Plastik</span>
                                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                </svg>
                                            </a>

                                            <!-- Submenu untuk Bedah Plastik -->
                                            <div
                                                class="absolute left-full top-0 w-80 bg-white shadow-lg opacity-0 invisible group-hover/sub:opacity-100 group-hover/sub:visible transition-all duration-200 z-50 border border-gray-200">
                                                <div class="py-2">
                                                    <!-- TUMMY TUCK -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/tummy-tuck/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">TUMMY TUCK</span>
                                                    </a>

                                                    <!-- SEDOT LEMAK -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/sedot-lemak/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">SEDOT LEMAK</span>
                                                    </a>

                                                    <!-- OPERASI HIDUNG -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/operasi-hidung/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">OPERASI HIDUNG</span>
                                                    </a>

                                                    <!-- PENGENCANGAN WAJAH -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/pengencangan-wajah/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                                        <span class="text-sm font-medium">PENGENCANGAN WAJAH</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Perawatan Kecantikan -->
                                        <div class="relative group/sub">
                                            <a href="#"
                                                class="flex items-center justify-between px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                                <span class="text-sm font-medium">Perawatan Kecantikan</span>
                                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                </svg>
                                            </a>

                                            <!-- Submenu untuk Perawatan Kecantikan -->
                                            <div
                                                class="absolute left-full top-0 w-80 bg-white shadow-lg opacity-0 invisible group-hover/sub:opacity-100 group-hover/sub:visible transition-all duration-200 z-50 border border-gray-200">
                                                <div class="py-2">
                                                    <!-- SKIN BOOSTER -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/skin-booster/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">SKIN BOOSTER</span>
                                                    </a>

                                                    <!-- BOTOX PREMIUM GERMAN -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/botox-premium-german/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">BOTOX PREMIUM GERMAN</span>
                                                    </a>

                                                    <!-- CREAM OTOPIK -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/cream-otopik/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150 border-b border-gray-100">
                                                        <span class="text-sm font-medium">CREAM OTOPIK</span>
                                                    </a>

                                                    <!-- VAGINA REJUVENATION -->
                                                    <a href="https://demowebjalan.com/klinikzenjogja/vagina-rejuvenation/"
                                                        class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                                        <span class="text-sm font-medium">VAGINA REJUVENATION</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Divider -->
                                        <div class="border-t border-gray-200 my-1"></div>

                                        <!-- Perawatan Nyeri -->
                                        <a href="#"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">Perawatan Nyeri</span>
                                        </a>

                                        <!-- MCU -->
                                        <a href="#"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">MCU</span>
                                        </a>

                                        <!-- Laboratorium -->
                                        <a href="#"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">Laboratorium</span>
                                        </a>

                                        <!-- Home care -->
                                        <a href="#"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">Home care</span>
                                        </a>

                                        <!-- Divider -->
                                        <div class="border-t border-gray-200 my-1"></div>

                                        <!-- Hasil pemeriksaan -->
                                        <a href="{{ route('results.selection') }}"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">Hasil pemeriksaan</span>
                                        </a>

                                        <!-- Hasil MCU perorangan & perusahaan -->
                                        <a href="{{ route('mcu.selection') }}"
                                            class="block px-4 py-3 text-gray-700 hover:bg-gray-100 transition duration-150">
                                            <span class="text-sm font-medium">Hasil MCU perorangan & perusahaan</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <a href="https://demowebjalan.com/klinikzenjogja/kabar-terbaru/"
                                class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold transition-all duration-200 hover:bg-white hover:bg-opacity-10">KABAR
                                TERBARU</a>
                            <a href="https://demowebjalan.com/klinikzenjogja/galeri/"
                                class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold transition-all duration-200 hover:bg-white hover:bg-opacity-10">GALERI</a>
                            <a href="https://demowebjalan.com/klinikzenjogja/cari-dokter/"
                                class="text-white hover:text-gray-200 px-4 py-3  text-sm font-semibold transition-all duration-200 hover:bg-white hover:bg-opacity-10">CARI
                                DOKTER</a>
                            <a href="{{ route('registration.create') }}"
                                class="bg-[#FFFFFF] text-[#3A3A3A] px-6 py-3 text-sm font-semibold transition-all duration-200 hover:shadow-lg">
                                REGISTRASI
                            </a>
                        </div>
                    </div>
                    <div class="md:hidden">
                        <button type="button"
                            class="text-white hover:text-gray-200 focus:outline-none focus:text-gray-200 p-2  hover:bg-white hover:bg-opacity-10 transition-all duration-200">
                            <svg class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main>
            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="bg-[#EEEE]">
            <!-- Upper Footer Section -->
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                    <!-- Left Column - Clinic Branding and Social Media -->
                    <div>
                        <!-- Logo -->
                        <div class="mb-4">
                            <div class="mb-3">
                                <img src="{{ asset('images/logo/LOGO_ZEN_PDF_page-0001-removebg-preview.png') }}"
                                    alt="Logo Zen" class="h-16 md:h-20 lg:h-28 w-auto object-contain"
                                    onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <div class="w-12 h-12 bg-gray-600 rounded-full flex items-center justify-center"
                                    style="display: none;">
                                    <span class="text-white font-bold text-2xl">Z</span>
                                </div>
                            </div>
                        </div>

                        <!-- Social Media Icons -->
                        <div class="flex space-x-3">
                            <a href="#"
                                class="w-10 h-10 bg-[#3a3a3a] rounded-full flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" aria-hidden="true">
                                    <rect x="3" y="3" width="18" height="18" rx="4"></rect>
                                    <circle cx="12" cy="12" r="4"></circle>
                                    <circle cx="17.5" cy="6.5" r="1"></circle>
                                </svg>
                            </a>
                            <a href="#"
                                class="w-10 h-10 bg-[#3a3a3a] rounded-full flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path
                                        d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z" />
                                </svg>
                            </a>
                            <a href="#"
                                class="w-10 h-10 bg-[#3a3a3a] rounded-full flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path
                                        d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                                </svg>
                            </a>
                        </div>
                    </div>

                    <!-- Middle Column - Navigation -->
                    <div>
                        <h4 class="text-lg font-bold text-gray-800 mb-4">NAVIGASI</h4>
                        <ul class="space-y-2">
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Home
                                </a>
                            </li>
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/tentang-kami/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Tentang Kami
                                </a>
                            </li>
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Layanan
                                </a>
                            </li>
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Kabar Terbaru
                                </a>
                            </li>
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Galeri
                                </a>
                            </li>
                            <li>
                                <a href="https://demowebjalan.com/klinikzenjogja/"
                                    class="flex items-center text-gray-700 hover:text-gray-900 transition duration-150">
                                    <svg class="w-4 h-4 mr-2 text-gray-600" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7"></path>
                                    </svg>
                                    Cari Dokter
                                </a>
                            </li>
                        </ul>
                    </div>

                    <!-- Right Column - Contact Information -->
                    <div>
                        <h4 class="text-lg font-bold text-gray-800 mb-4">INFO KONTAK</h4>
                        <div class="space-y-3">
                            <div class="flex items-start">
                                <svg class="w-5 h-5 text-[#3a3a3a] mt-0.5 mr-3 flex-shrink-0" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                    </path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                <div>
                                    <p class="text-gray-700 font-medium">Alamat:</p>
                                    <p class="text-gray-600">Dukuh, Tridadi, Kec. Sleman, Kab. Sleman Yogyakarta</p>
                                </div>
                            </div>

                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-[#3a3a3a] mr-3 flex-shrink-0" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                    </path>
                                </svg>
                                <p class="text-gray-600">0811 254 973</p>
                            </div>

                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-[#3a3a3a] mr-3 flex-shrink-0" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                    </path>
                                </svg>
                                <p class="text-gray-600">0811 254 973</p>
                            </div>

                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-[#3a3a3a] mr-3 flex-shrink-0" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                    </path>
                                </svg>
                                <p class="text-gray-600">klinikzenjogja@gmail.com</p>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        <h4 class="text-lg font-bold text-gray-800 mb-4">INFO KONTAK</h4>
                        <div>
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d5831.085449784508!2d110.3542824088539!3d-7.713958675032013!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e7a5f000aaf370b%3A0xd407edd55eda5914!2sKlinik%20Bedah%20Plastik%20dr%20Bayu%20Suhartadi%20SpBP-RE!5e0!3m2!1sid!2sid!4v1761739610305!5m2!1sid!2sid" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Footer Section -->
            <div class="bg-[#3a3a3a] py-4">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex flex-col sm:flex-row justify-between items-center">
                        <div class="text-white text-sm mb-2 sm:mb-0">
                            © 2025 Klinik Zen Jogja. All Rights Reserved. Supported by IT Solution®
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- JavaScript for scroll to top -->
    <script>
        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }
    </script>
</body>

</html>
